-- events 


-- Strings that need localization
--
function OnLoad ()
	SetProperty ("/ContinueOldGame:enter_trans_duration", 0.3);
	SetProperty ("/ContinueOldGame:leave_trans_duration", 0.3);
	CacheSound ("ui/sfx/panel_move.ogg");
	CacheSound ("sfx/gained_something.ogg");
end;


function OnEnter ()
    PlaySound ("ui/sfx/panel_move.ogg");
	level = GetProfileValue ("level");
	score = GetProfileValue ("total_score");

	saved_in = GetProfileValue ("saved_in");
	
	if (saved_in == "HiddenObject") then
		level_number = GetProfileValue ("level_number")-1;
		episode = math.floor (level_number/7);
		val = DM_GetValue ("xml/story.xml", "minigame_story", episode-1, "title");
		desc = Localize (val); -- these have already been localized elsewhere on load time
	else
		desc = string.format ("%s", level);
	end;
	
	SetProperty ("desc:label.text", desc);

end;

function OnLeave ()
end;


function OnClick (name)

	if (name == "Continue") then
	    PlaySound ("sfx/gained_something.ogg");
		LoadGameState ();
		PopScreen ("MainMenu");
		PopScreen ("ContinueOldGame");
		saved_in = GetProfileValue ("saved_in");
		if (saved_in == "WorldMap") then
			SwitchScreen ("WorldMap");
		elseif (saved_in == "HiddenObject") then
			lev_num_completed = GetGameValue ("level_number")-1;
			episode = math.floor (lev_num_completed / 7);
			Print ("Episode number is "..episode.."\n");
			SwitchScreen ("HiddenWorld");--..episode);
			--SwitchScreen ("HiddenWorld01");
		else
		
			SwitchScreen ("Game");
		end;
		return;
	end;
	
	if (name == "NewGame") then
		PushScreen ("NewGameConfirmation");
		return;
	end;
	
	if (name == "Cancel") then
	    PlaySound ("ui/sfx/panel_move.ogg");
		PopScreen ("ContinueOldGame");
		return;
	end;
end;


function OnUpdate (tdelta)
	
	akey = GetActiveScreenAnimKey ();

	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());
	SetProperty ("panel:position_offset.y", (1-trans) * 600);
	SetProperty ("panel:alpha", trans);
	SetProperty ("fader:alpha", trans + trans * 0.05 * math.sin (2*3.141592*akey));
end;

function OnDraw ()

end;
